<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <!-- Least Squares Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis metody nejmenších čtverců Výškově</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <xsl:for-each select="AdjustmentNet">
                                <center>
                                    <!-- Report Title -->
                                    <h2 lang="en">Výpis metody nejmenších čtverců Výškově</h2>
                                    <p lang="en">
                                        Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                        Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                    </p>
                                </center>
                                <p lang="en" style="text-align:center;font-size:80%">
                                    <strong>Aktivní geografický systém:&#xa0;</strong>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemName"/>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemDescription"/>
                                    <xsl:if test="//@linearUnits = 'I'">, stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'F'">, Survey stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'M'">, metry</xsl:if>
                                </p>
                                <hr/>
                                <center>
                                    <h4>Výškově metoda nejmenších čtverců</h4>
                                </center>
                                <hr size="1px"/>
                                <xsl:for-each select="OneDFileReport">
                                    <xsl:for-each select="OneDFileReportList">
                                        <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <xsl:for-each select="ElevationDifference">
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <tbody>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">MISCLOSURE OF MULTIPLE ELEVATION DIFFERENCE MEASUREMENTSe&#xa0;</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <colgroup span="3">
                                                        <col width="20%"/>
                                                        <col width="20%"/>
                                                        <col width="20%"/>
                                                    </colgroup>
                                                    <thead style="display:table-header-group">
                                                        <tr>
                                                            <th class="underline" lang="en" align="left">
                                                                Ze<br/>stanice
                                                            </th>
                                                            <th class="underline" lang="en" align="left">
                                                                Do<br/>stanice
                                                            </th>
                                                            <th class="underline" lang="en" align="right">Chyba uzavření</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <xsl:for-each select="ElevationDifferenceList">
                                                            <xsl:choose>
                                                                <xsl:when test="@isAsterisk='True'">
                                                                    <tr style="color:FF0000">
                                                                        <td align="left">
                                                                            <xsl:value-of select="@fromStation"/>
                                                                        </td>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@toStation"/>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@misClosure='*******'">
                                                                                    <xsl:value-of select="@misClosure"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@misClosure))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="left">*</td>
                                                                    </tr>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <tr>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@fromStation"/>
                                                                        </td>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@toStation"/>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@misClosure='*******'">
                                                                                    <xsl:value-of select="@misClosure"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@misClosure))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                    </tr>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </table>
                                            </xsl:for-each>
                                            <xsl:for-each select="BenchMarkElevationResiduals">
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <tbody>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">TEST ZBYTEK VÝŠKY&#xa0;</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <colgroup span="5">
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                    </colgroup>
                                                    <thead style="display:table-header-group">
                                                        <tr>
                                                            <th class="underline" lang="en" align="left">Stanice</th>
                                                            <th class="underline" lang="en" align="right">
                                                                Vstupní<br/>výška
                                                            </th>
                                                            <th class="underline" lang="en" align="right">
                                                                Vyrovnaná<br/>výška
                                                            </th>
                                                            <th class="underline" lang="en" align="right">Zbytek</th>
                                                            <th class="underline" lang="en" align="right">Standardizovaný zbytek</th>
                                                            <th class="underline" lang="en" align="right">
                                                                Chyba<br/>Odhad
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <xsl:for-each select="BenchMarkElevationResidualsList">
                                                            <xsl:choose>
                                                                <xsl:when test="@isAsterisk='True'">
                                                                    <tr style="color:FF0000">
                                                                        <td align="left">
                                                                            <xsl:value-of select="@stationName"/>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@inputElevation='*******'">
                                                                                    <xsl:value-of select="@inputElevation"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:ordinateFormat(number(@inputElevation))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@adjustedElevation='*******'">
                                                                                    <xsl:value-of select="@adjustedElevation"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:ordinateFormat(number(@adjustedElevation))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@residual='*******'">
                                                                                    <xsl:value-of select="@residual"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@snoopError='*******'">
                                                                                    <xsl:value-of select="@snoopError"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@errorEstimate='*******'">
                                                                                    <xsl:value-of select="@errorEstimate"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="left">*</td>
                                                                    </tr>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <tr>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@stationName"/>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@inputElevation='*******'">
                                                                                    <xsl:value-of select="@inputElevation"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:ordinateFormat(number(@inputElevation))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@adjustedElevation='*******'">
                                                                                    <xsl:value-of select="@adjustedElevation"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:ordinateFormat(number(@adjustedElevation))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@residual='*******'">
                                                                                    <xsl:value-of select="@residual"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@snoopError='*******'">
                                                                                    <xsl:value-of select="@snoopError"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@errorEstimate='*******'">
                                                                                    <xsl:value-of select="@errorEstimate"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                    </tr>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </table>
                                            </xsl:for-each>
                                            <xsl:for-each select="BenchMarkStats">
                                                <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                    <tbody>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">TEST RMS CHYBA = &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="cif:distanceFormat(number(@rmsError))"/>
                                                            </td>
                                                            <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS CHYBA = &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">MAX. TEST RMS CHYBA VE STANICI &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="@stationName"/>
                                                            </td>
                                                            <th align="left" nowrap="nowrap"> Z &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </xsl:for-each>
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <xsl:for-each select="LevelDifferenceResiduals">
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <tbody>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">VÝŠK. ROZDÍL ZBYTKY&#xa0;</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <colgroup span="5">
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                        <col width="15%"/>
                                                    </colgroup>
                                                    <thead style="display:table-header-group">
                                                        <tr>
                                                            <th class="underline" lang="en" align="left">
                                                                Ze<br/>stanice
                                                            </th>
                                                            <th class="underline" lang="en" align="left">
                                                                Do<br/>stanice
                                                            </th>
                                                            <th class="underline" lang="en" align="right">Měřená</th>
                                                            <th class="underline" lang="en" align="right">Zbytek</th>
                                                            <th class="underline" lang="en" align="right">Standardizovaný zbytek</th>
                                                            <th class="underline" lang="en" align="right">
                                                                Chyba<br/>Odhad
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <xsl:for-each select="LevelDifferenceResidualsList">
                                                            <xsl:choose>
                                                                <xsl:when test="@isAsterisk='True'">
                                                                    <tr style="color:FF0000">
                                                                        <td align="left">
                                                                            <xsl:value-of select="@fromStation"/>
                                                                        </td>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@toStation"/>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@measured='*******'">
                                                                                    <xsl:value-of select="@measured"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@measured))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@residual='*******'">
                                                                                    <xsl:value-of select="@residual"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@snoopError='*******'">
                                                                                    <xsl:value-of select="@snoopError"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@errorEstimate='*******'">
                                                                                    <xsl:value-of select="@errorEstimate"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="left">*</td>
                                                                    </tr>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <tr>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@fromStation"/>
                                                                        </td>
                                                                        <td align="left">
                                                                            <xsl:value-of select="@toStation"/>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@measured='*******'">
                                                                                    <xsl:value-of select="@measured"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@measured))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@residual='*******'">
                                                                                    <xsl:value-of select="@residual"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@snoopError='*******'">
                                                                                    <xsl:value-of select="@snoopError"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                        <td align="right">
                                                                            <xsl:choose>
                                                                                <xsl:when test="@errorEstimate='*******'">
                                                                                    <xsl:value-of select="@errorEstimate"/>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </td>
                                                                    </tr>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </table>
                                            </xsl:for-each>

                                            <xsl:for-each select="LevelDifferenceStats">
                                                <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                    <tbody>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">VÝŠK. ROZDÍL RMS CHYBA = &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="cif:distanceFormat(number(@rmsError))"/>
                                                            </td>
                                                            <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS CHYBA = &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">MAX. VÝŠK. ROZDÍL ZBYTEK VE STANICI &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="@fromStation"/>
                                                            </td>
                                                            <th align="left" nowrap="nowrap"> - &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="@toStation"/>
                                                            </td>
                                                            <th align="left" nowrap="nowrap"> Z &#xa0;</th>
                                                            <td align="left" nowrap="nowrap">
                                                                <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </xsl:for-each>
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            
                                            <xsl:for-each select="AdjustedElevations">
                                                <table class="margin" cellpadding="1" cellspacing="1" width="40%">
                                                    <tbody>
                                                        <tr>
                                                            <th align="left" nowrap="nowrap">VYROVNANÉ VÝŠKY&#xa0;</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <table class="margin" cellpadding="1" cellspacing="1" width="40%">
                                                    <colgroup span="3">
                                                        <col width="10%"/>
                                                        <col width="10%"/>
                                                        <col width="10%"/>
                                                    </colgroup>
                                                    <thead style="display:table-header-group">
                                                        <tr>
                                                            <th class="underline" lang="en" align="left">Stanice</th>
                                                            <th class="underline" lang="en" align="right">
                                                                 Vyrovnaná<br/>výška
                                                            </th>
                                                            <th class="underline" lang="en" align="right">
                                                                Standardní<br/>chyba
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <xsl:for-each select="AdjustedElevationsList">
                                                            <tr>
                                                                <td align="left">
                                                                    <xsl:value-of select="@stationName"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:ordinateFormat(number(@adjustedElevation))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@standardError))"/>
                                                                </td>
                                                            </tr>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </table>
                                            </xsl:for-each>
                                        </table>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
       </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
               Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje síť měření s provedeným vyrovnáním. </p>

      <p class="normal1">  V Průzkumníku projektu se ujistěte, že vpravo od Vyrovnání svítí zelená značka (ukazuje kompletní provedení). Pravým kliknutím na Vyrovnání vyberte Výsledky vyrovnání pro odpovídající výpis. </p>
      <p class="normal1"> Po otevření Průzkumníka výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
      <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
    </xsl:stylesheet>
